#include <SPI.h>
#include "2inch9_epd.h"
#include "Ap_29demo.h"
#include "epd_gui.h"

/***************************************************************************************
 * Project  :
 * Experimental Platform :Arduino ESP32 + 2.9inch E-Paper Display
 * Hardware Connection :Arduino ESP32-> 2.9inch E-Paper
 *      IO27 --> CS
 *      IO18 --> CLK
 *      IO23 --> MOSI
 *      IO14  --> DC
 *      IO33  --> RST
 *      IO13  --> BUSY
 * Web Site    :www.seengreat.com
***************************************************************************************/
/******************************
 * image :
 * 0------------> x (1~168) 
 * |
 * |
 * |
 * |
 * y (1~384)
 * 
 * */

unsigned char image[16128];  //Define canvas space
void setup() {
	pinMode(BUSY_Pin, INPUT);  //BUSY
	pinMode(RES_Pin, OUTPUT);  //RES
	pinMode(DC_Pin, OUTPUT);   //DC
	pinMode(CS_Pin, OUTPUT);   //CS
	//SPI
	SPI.beginTransaction(SPISettings(10000000, MSBFIRST, SPI_MODE0));
	SPI.begin();
}

//Tips//
/*
1.Flickering is normal when EPD is performing a full screen update to clear ghosting from the previous image so to ensure better clarity and legibility for the new image.
2.There will be no flicker when EPD performs a partial refresh.
3.Please make sue that EPD enters sleep mode when refresh is completed and always leave the sleep mode command. Otherwise, this may result in a reduced lifespan of EPD.
4.Please refrain from inserting EPD to the FPC socket or unplugging it when the MCU is being powered to prevent potential damage.)
5.Re-initialization is required for every full screen update.
6.When porting the program, set the BUSY pin to input mode and other pins to output mode.
*/
void loop() {
	unsigned char i;

	EPD_HW_Init();
	PIC_display(gImage_1);  
	EPD_DeepSleep();        //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
	delay(2000);            //Delay for 2s.

	// EPD_HW_Init();
	// EPD_WhiteScreen_Red();
	// EPD_DeepSleep();        //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
	// delay(1000);

	// EPD_HW_Init();
	// EPD_WhiteScreen_Yellow();
	// EPD_DeepSleep();        //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
	// delay(1000);

	EPD_HW_Init();
	Image_Init(image, EPD_WIDTH, EPD_HEIGHT, 270, EPD_2IN9G_WHITE);
	//			  /**************Drawing**********************/
	Gui_Clear(EPD_2IN9G_WHITE);
	//Point
	Gui_Draw_Point(3, 1, EPD_2IN9G_BLACK, PIXEL_1X1, DOT_STYLE_DFT);
	Gui_Draw_Point(3, 15, EPD_2IN9G_YELLOW, PIXEL_2X2, DOT_STYLE_DFT);
	Gui_Draw_Point(5, 40, EPD_2IN9G_RED, PIXEL_3X3, DOT_STYLE_DFT);
	Gui_Draw_Point(5, 55, EPD_2IN9G_BLACK, PIXEL_4X4, DOT_STYLE_DFT);
	//Line
	Gui_Draw_Line(15, 5, 55, 110, EPD_2IN9G_BLACK, PIXEL_1X1, SOLID);
	Gui_Draw_Line(15, 50, 55, 10, EPD_2IN9G_BLACK, PIXEL_1X1, SOLID);
	//Rectangle
	Gui_Draw_Rectangle(15, 5, 55, 45, EPD_2IN9G_BLACK, EMPTY, PIXEL_1X1);
	Gui_Draw_Rectangle(90, 5, 130, 45, EPD_2IN9G_BLACK, FULL, PIXEL_1X1);
	//Circle
	Gui_Draw_Circle(170, 25, 18, EPD_2IN9G_YELLOW, EMPTY, PIXEL_1X1);
	Gui_Draw_Circle(226, 25, 18, EPD_2IN9G_RED, FULL, PIXEL_1X1);
	Gui_Draw_Str(60, 50, "168x384", &Font16, EPD_2IN9G_WHITE, EPD_2IN9G_YELLOW);        //7*12
	Gui_Draw_Str(145, 50, "SPI interface", &Font16, EPD_2IN9G_WHITE, EPD_2IN9G_RED);    //11*16
	Gui_Draw_Str(80, 75, "2.9\" E-Paper", &Font20, EPD_2IN9G_WHITE, EPD_2IN9G_YELLOW);  //14*20
	Gui_Draw_Str(80, 100, "SEENGREAT", &Font24, EPD_2IN9G_WHITE, EPD_2IN9G_RED);        //17*24


	GUI_display(image);
	EPD_DeepSleep();  //EPD_DeepSleep,Sleep instruction is necessary, please do not delete!!!
	delay(2000);      //2s
	delay(2000);      //2s

	EPD_HW_Init();            
	EPD_WhiteScreen_White();  //Clear screen function.
	delay(1000);              //Delay for 2s.
	while (1)
		;  // The program stops here
}
//////////////////////////////////END//////////////////////////////////////////////////
